<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDeliveryTable extends Migration {

	public function up()
	{
		Schema::create('delivery', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->string('name')->nullable();
			$table->string('phone')->nullable();
			$table->double('salary');
			$table->double('commission')->nullable();
			$table->string('address')->nullable();
			$table->string('ssn')->nullable();
			$table->string('moto_number')->nullable();
			$table->string('license_number')->nullable();
			$table->date('expire_date')->nullable();
			$table->string('city')->nullable();
			$table->string('country')->nullable();
			$table->text('note')->nullable();
			$table->string('extra1')->nullable();
			$table->string('extra2')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('delivery');
	}
}