<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('user_employees', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code', 100)->unique();
			$table->string('first_name', 100)->index();
			$table->string('last_name', 100)->nullable();
			$table->string('title', 50)->nullable();
			$table->string('gender', 20)->default('male');
			$table->string('phone', 25)->unique();
			$table->string('ktp', 20)->unique();
			$table->string('ktp_image', 50)->nullable();
			$table->string('npwp', 50)->unique()->nullable();
			$table->string('kk', 50)->unique()->nullable();
			$table->string('kk_image', 50)->nullable();
			$table->string('bank_name', 25);
			$table->string('bank_branch', 50);
			$table->string('bank_account_number', 25);
			$table->string('bank_account_name', 100);
			$table->text('address');
			$table->integer('location_id')->unsigned();
			$table->string('location_name', 191);
			$table->string('postcode', 5)->nullable();
			$table->integer('company_id')->unsigned();
			$table->integer('position_id')->unsigned()->index();
			$table->string('position_name', 50)->index();
			$table->string('recomendation_ref', 50)->nullable()->index();
			$table->string('status', 20)->default('draft');
			$table->string('created_by', 50)->nullable();
			$table->string('updated_by', 50)->nullable();
			$table->string('deleted_by', 50)->nullable();
			$table->text('attributes')->nullable();
			$table->softDeletes();
			$table->timestamps();
			$table->string('company_name', 100)->index();
		});
	}

	public function down()
	{
		Schema::drop('user_employees');
	}
}