<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('reference');
			$table->bigIncrements('member_id');
			$table->integer('benefit_program_id');
			$table->date('start_date');
			$table->date('end_date');
			$table->json('meta_data')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}