<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMemberTable extends Migration {

	public function up()
	{
		Schema::create('member', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('first_name');
			$table->string('last_name');
			$table->string('gender');
			$table->date('birthdate');
			$table->string('external_id')->index();
			$table->string('governmental_id');
			$table->string('phonenumber');
			$table->string('email');
			$table->string('country');
			$table->json('meta_data');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('member');
	}
}