<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('color_id')->references('id')->on('colors')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('members', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('members', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('members', function(Blueprint $table) {
			$table->foreign('member_relation_id')->references('id')->on('member_relations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('feedbacks', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('important_dates', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('important_dates', function(Blueprint $table) {
			$table->foreign('color_id')->references('id')->on('colors')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('important_dates', function(Blueprint $table) {
			$table->foreign('family_member_id')->references('id')->on('members')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('important_date_member', function(Blueprint $table) {
			$table->foreign('important_date_id')->references('id')->on('important_dates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('important_date_member', function(Blueprint $table) {
			$table->foreign('memer_id')->references('id')->on('members')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_country_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_country_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_color_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_client_id_foreign');
		});
		Schema::table('members', function(Blueprint $table) {
			$table->dropForeign('members_country_id_foreign');
		});
		Schema::table('members', function(Blueprint $table) {
			$table->dropForeign('members_client_id_foreign');
		});
		Schema::table('members', function(Blueprint $table) {
			$table->dropForeign('members_member_relation_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_client_id_foreign');
		});
		Schema::table('feedbacks', function(Blueprint $table) {
			$table->dropForeign('feedbacks_client_id_foreign');
		});
		Schema::table('important_dates', function(Blueprint $table) {
			$table->dropForeign('important_dates_category_id_foreign');
		});
		Schema::table('important_dates', function(Blueprint $table) {
			$table->dropForeign('important_dates_color_id_foreign');
		});
		Schema::table('important_dates', function(Blueprint $table) {
			$table->dropForeign('important_dates_family_member_id_foreign');
		});
		Schema::table('important_date_member', function(Blueprint $table) {
			$table->dropForeign('important_date_member_important_date_id_foreign');
		});
		Schema::table('important_date_member', function(Blueprint $table) {
			$table->dropForeign('important_date_member_memer_id_foreign');
		});
	}
}