<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentCourseTable extends Migration {

	public function up()
	{
		Schema::create('student_course', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('student_id')->unsigned();
			$table->bigInteger('course_id')->unsigned();
			$table->float('amount');
			$table->bigInteger('payment_id')->unsigned()->nullable();
			$table->boolean('is_active');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('student_course');
	}
}