<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBooksTable extends Migration {

	public function up()
	{
		Schema::create('books', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('course_id')->unsigned();
			$table->string('book_pdf');
			$table->boolean('is_bw');
			$table->float('bw_price');
			$table->boolean('is_colored');
			$table->float('colored_price');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('books');
	}
}