<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateManagersTable extends Migration {

	public function up()
	{
		Schema::create('managers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('email')->unique();
			$table->string('password');
			$table->string('birthdate');
			$table->string('phone')->unique();
			$table->enum('gender', array('MALE', 'FEMALE'));
			$table->string('image')->nullable();
			$table->string('cv_pdf')->nullable();
			$table->mediumText('cv_description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('managers');
	}
}