<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('email')->unique();
			$table->string('password');
			$table->string('communication_code')->unique();
			$table->text('address');
			$table->string('birthdate');
			$table->string('phone')->unique();
			$table->enum('gender', array('MALE', 'FEMALE'));
			$table->string('image');
			$table->timestamps();
			$table->boolean('is_active')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}