<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('questions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('exam_id')->unsigned()->nullable();
			$table->bigInteger('indicator_id')->unsigned()->nullable();
			$table->bigInteger('standard_id')->unsigned()->nullable();
			$table->string('content');
			$table->string('image');
			$table->float('degree');
			$table->boolean('is_active');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('questions');
	}
}