<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('payment_type', array('CASH', 'EPYAMENT'));
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->float('amount');
			$table->enum('type', array('CART', 'CERTIFICATE'));
			$table->boolean('is_confirmed');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}