<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDevicesTable extends Migration {

	public function up()
	{
		Schema::create('devices', function(Blueprint $table) {
			$table->integer('id')->unsigned();
			$table->string('serial');
			$table->tinyInteger('status')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('enrolled')->unsigned();
			$table->integer('site_id')->unsigned();
			$table->tinyInteger('case_supplied')->unsigned();
			$table->datetime('date_added');
			$table->datetime('updated');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('devices');
	}
}