<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Item extends Eloquent {

	protected $table = 'items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function itemc()
	{
		return $this->belongsTo('ItemCategory');
	}

	public function itemcon()
	{
		return $this->hasOne('ItemContent');
	}

	public function itemr()
	{
		return $this->hasMany('ItemResource');
	}

	public function iteml()
	{
		return $this->hasMany('ItemLike');
	}

	public function itemcom()
	{
		return $this->hasMany('ItemComment');
	}

	public function itemf()
	{
		return $this->hasMany('ItemFavourite');
	}

	public function itemnotify()
	{
		return $this->hasMany('UserNotification');
	}

	public function item_group()
	{
		return $this->hasOne('Group');
	}

}