<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Site extends Eloquent {

	protected $table = 'sites';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function site()
	{
		return $this->hasMany('Social');
	}

	public function site()
	{
		return $this->hasMany('SiteUser');
	}

	public function site()
	{
		return $this->belongsTo('Trust');
	}

	public function site()
	{
		return $this->hasMany('GroupSite');
	}

	public function logsite()
	{
		return $this->hasMany('SafeguardingLog');
	}

	public function sitesl()
	{
		return $this->hasMany('SiteSlots');
	}

	public function termsite()
	{
		return $this->hasOne('SiteTerms');
	}

}