<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function userrole()
    {
        return $this->hasOne('RoleUser');
    }

    public function user()
    {
        return $this->belongsTo('RoleUser');
    }

    public function user()
    {
        return $this->hasOne('Profile');
    }

    public function userbank()
    {
        return $this->hasMany('PassBank');
    }

    public function userupn()
    {
        return $this->hasOne('UPNLookup');
    }

    public function usertech()
    {
        return $this->hasMany('Device');
    }

    public function session()
    {
        return $this->hasOne('Session');
    }

}