<?php

namespace App\Models;

class Roget extends Eloquent {

	protected $table = 'rogets';
	public $timestamps = true;
	protected $fillable = array('pationt_id', 'file_id');

	public function file()
	{
		return $this->belongsTo('App\Models\File');
	}

	public function pationt()
	{
		return $this->belongsTo('App\Models\Pationt');
	}

	public function writenMeidcine()
	{
		return $this->hasMany('App\Models\WritenRoget');
	}

	public function medicines()
	{
		return $this->belongsToMany('App\Models\Medicine');
	}

	public function medicine_quantities()
	{
		return $this->morphMany('App\Models\MedicineQuantity');
	}

}