<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionTable extends Migration {

	public function up()
	{
		Schema::create('subscription', function(Blueprint $table) {
			$table->increments('id');
			$table->datetime('deleted_at');
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->text('name');
			$table->decimal('price_per_device_usd');
			$table->decimal('price_per_device_eur');
			$table->decimal('price_per_device_brl');
			$table->text('plan_type')->default('monthly');
			$table->string('min_number_devices');
			$table->string('max_number_devices');
			$table->string('trial_days');
			$table->text('google_subscription_id');
		});
	}

	public function down()
	{
		Schema::drop('subscription');
	}
}