<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscribersTable extends Migration {

	public function up()
	{
		Schema::create('subscribers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('status');
			$table->string('user_id');
			$table->text('user_name');
			$table->text('user_email');
			$table->string('subscription_id');
			$table->datetime('payment_date');
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->text('first_payment');
			$table->datetime('expiration_date');
			$table->string('devices_slots');
			$table->string('price');
			$table->text('currency');
			$table->text('provider');
			$table->string('order_id');
			$table->string('token');
			$table->datetime('cancelled_at');
			$table->string('cancelled_reason');
			$table->string('cancelled_user_reason');
			$table->string('cancelled_reason_input');
		});
	}

	public function down()
	{
		Schema::drop('subscribers');
	}
}