<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Event extends Eloquent {

	protected $table = 'events';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'slug', 'cpd_hours', 'start_date', 'end_date', 'next_date', 'start_time', 'end_time', 'short_description', 'description', 'banner', 'is_active', 'registration_instructions', 'type');

	public function dates()
	{
		return $this->hasMany('Date');
	}

}