<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGameItemsTable extends Migration {

	public function up()
	{
		Schema::create('game_items', function(Blueprint $table) {
			$table->increments('id');
			$table->string('market_hash_name', 200);
			$table->smallInteger('app_id');
			$table->bigInteger('classid');
			$table->float('fixedprice', 8,2)->default('0.00');
			$table->timestamps();
			$table->integer('steam_game_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('game_items');
	}
}