<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSteamGamesTable extends Migration {

	public function up()
	{
		Schema::create('steam_games', function(Blueprint $table) {
			$table->increments('id');
			$table->smallInteger('app_id')->unsigned();
			$table->string('realname', 175)->nullable();
			$table->string('name', 100);
			$table->string('headerimg', 200)->nullable();
			$table->string('capsule', 200)->nullable();
			$table->string('banner', 250)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('steam_games');
	}
}