<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStateDistrictLocalBodiesTable extends Migration {

	public function up()
	{
		Schema::create('state_district_local_bodies', function(Blueprint $table) {
			$table->string('id', 255)->primary();
			$table->string('state', 255);
			$table->string('district', 255);
			$table->string('local_body');
			$table->enum('local_body_classification', array('village', 'municipality', 'sub-metropolitian', 'metropolitian'));
			$table->enum('ward', array('1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31', '32', '33', '34', '35', '36'));
			$table->integer('household');
			$table->integer('population');
			$table->tinyInteger('active')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('state_district_local_bodies');
	}
}