<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('permission_roles', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permission_roles', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('menus', function(Blueprint $table) {
			$table->foreign('module_id')->references('id')->on('modules')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('menus', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('menus')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stations', function(Blueprint $table) {
			$table->foreign('state_district_local_body_id')->references('id')->on('state_district_local_bodies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stations', function(Blueprint $table) {
			$table->foreign('contact_person_id')->references('id')->on('contact_persons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->foreign('contact_person_id')->references('id')->on('contact_persons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('warehouses', function(Blueprint $table) {
			$table->foreign('state_district_local_body_id')->references('id')->on('state_district_local_bodies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('warehouse_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('warehouse_user', function(Blueprint $table) {
			$table->foreign('warehouse_id')->references('id')->on('warehouses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('item_unit_id')->references('id')->on('item_units')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_stocks', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_stocks', function(Blueprint $table) {
			$table->foreign('warehouse_id')->references('id')->on('warehouses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_stocks', function(Blueprint $table) {
			$table->foreign('plot_id')->references('id')->on('plots')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('station_requests', function(Blueprint $table) {
			$table->foreign('station_id')->references('id')->on('stations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('station_requests', function(Blueprint $table) {
			$table->foreign('requested_by_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('station_requests', function(Blueprint $table) {
			$table->foreign('issured_by_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('station_item_request_items', function(Blueprint $table) {
			$table->foreign('station_request_id')->references('id')->on('station_requests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('station_item_request_items', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('station_item_request_items', function(Blueprint $table) {
			$table->foreign('warehouse_id')->references('id')->on('warehouses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_transactions', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_transactions', function(Blueprint $table) {
			$table->foreign('station_id')->references('id')->on('stations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_transactions', function(Blueprint $table) {
			$table->foreign('warehouse_id')->references('id')->on('warehouses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_transactions', function(Blueprint $table) {
			$table->foreign('decision_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('permission_roles', function(Blueprint $table) {
			$table->dropForeign('permission_roles_permission_id_foreign');
		});
		Schema::table('permission_roles', function(Blueprint $table) {
			$table->dropForeign('permission_roles_role_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_role_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_user_id_foreign');
		});
		Schema::table('menus', function(Blueprint $table) {
			$table->dropForeign('menus_module_id_foreign');
		});
		Schema::table('menus', function(Blueprint $table) {
			$table->dropForeign('menus_parent_id_foreign');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_id_foreign');
		});
		Schema::table('stations', function(Blueprint $table) {
			$table->dropForeign('stations_state_district_local_body_id_foreign');
		});
		Schema::table('stations', function(Blueprint $table) {
			$table->dropForeign('stations_contact_person_id_foreign');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->dropForeign('suppliers_contact_person_id_foreign');
		});
		Schema::table('warehouses', function(Blueprint $table) {
			$table->dropForeign('warehouses_state_district_local_body_id_foreign');
		});
		Schema::table('warehouse_user', function(Blueprint $table) {
			$table->dropForeign('warehouse_user_user_id_foreign');
		});
		Schema::table('warehouse_user', function(Blueprint $table) {
			$table->dropForeign('warehouse_user_warehouse_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_item_unit_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_supplier_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_category_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_parent_id_foreign');
		});
		Schema::table('item_stocks', function(Blueprint $table) {
			$table->dropForeign('item_stocks_item_id_foreign');
		});
		Schema::table('item_stocks', function(Blueprint $table) {
			$table->dropForeign('item_stocks_warehouse_id_foreign');
		});
		Schema::table('item_stocks', function(Blueprint $table) {
			$table->dropForeign('item_stocks_plot_id_foreign');
		});
		Schema::table('station_requests', function(Blueprint $table) {
			$table->dropForeign('station_requests_station_id_foreign');
		});
		Schema::table('station_requests', function(Blueprint $table) {
			$table->dropForeign('station_requests_requested_by_user_id_foreign');
		});
		Schema::table('station_requests', function(Blueprint $table) {
			$table->dropForeign('station_requests_issured_by_user_id_foreign');
		});
		Schema::table('station_item_request_items', function(Blueprint $table) {
			$table->dropForeign('station_item_request_items_station_request_id_foreign');
		});
		Schema::table('station_item_request_items', function(Blueprint $table) {
			$table->dropForeign('station_item_request_items_item_id_foreign');
		});
		Schema::table('station_item_request_items', function(Blueprint $table) {
			$table->dropForeign('station_item_request_items_warehouse_id_foreign');
		});
		Schema::table('item_transactions', function(Blueprint $table) {
			$table->dropForeign('item_transactions_item_id_foreign');
		});
		Schema::table('item_transactions', function(Blueprint $table) {
			$table->dropForeign('item_transactions_station_id_foreign');
		});
		Schema::table('item_transactions', function(Blueprint $table) {
			$table->dropForeign('item_transactions_warehouse_id_foreign');
		});
		Schema::table('item_transactions', function(Blueprint $table) {
			$table->dropForeign('item_transactions_decision_by_foreign');
		});
	}
}