<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfilesTable extends Migration {

	public function up()
	{
		Schema::create('profiles', function(Blueprint $table) {
			$table->integer('id')->unsigned();
			$table->string('first_name', 255);
			$table->string('last_name', 255);
			$table->string('middle_name', 255);
			$table->enum('gender', array('male', 'female'));
			$table->date('dob');
			$table->string('phone', 20);
			$table->string('current_address', 255);
			$table->string('permanent_address', 255);
		});
	}

	public function down()
	{
		Schema::drop('profiles');
	}
}