<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('order_info', function(Blueprint $table) {
			$table->foreign('Institute')->references('school_id')->on('school')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order_info', function(Blueprint $table) {
			$table->foreign('fk_customer_id')->references('customer_id')->on('customer')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order_item_measurement', function(Blueprint $table) {
			$table->foreign('fk_order_item_id')->references('order_item_id')->on('order_item')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('order_item_measurement', function(Blueprint $table) {
			$table->foreign('fk_dressType')->references('dresses_id')->on('dresses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order_item_measurement', function(Blueprint $table) {
			$table->foreign('fk_measurement_header')->references('measurement_id')->on('measurements')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('payment', function(Blueprint $table) {
			$table->foreign('fk_order_id')->references('order_id')->on('order_info')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('style', function(Blueprint $table) {
			$table->foreign('fk_order_item_id')->references('order_item_id')->on('order_item')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('style', function(Blueprint $table) {
			$table->foreign('fk_header')->references('sub_category_id')->on('corporate_style_sub_category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('classes', function(Blueprint $table) {
			$table->foreign('fk_school')->references('school_id')->on('school')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('order_item', function(Blueprint $table) {
			$table->foreign('fk_order_id')->references('order_id')->on('order_info')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('order_item', function(Blueprint $table) {
			$table->foreign('fk_dressType')->references('dresses_id')->on('dresses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order_status_log', function(Blueprint $table) {
			$table->foreign('fk_order_id')->references('order_id')->on('order_info')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('order_status_log', function(Blueprint $table) {
			$table->foreign('added_by')->references('user_id')->on('user')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('ordered_addons', function(Blueprint $table) {
			$table->foreign('fk_order_id')->references('order_id')->on('order_info')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('ordered_addons', function(Blueprint $table) {
			$table->foreign('fk_addons')->references('id')->on('addons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customer', function(Blueprint $table) {
			$table->foreign('fk_user_id')->references('user_id')->on('user')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('corporate_style_category', function(Blueprint $table) {
			$table->foreign('fk_company')->references('company_id')->on('company')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('corporate_style_sub_category', function(Blueprint $table) {
			$table->foreign('category_id')->references('style_category_id')->on('corporate_style_category')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('school_class_measurement', function(Blueprint $table) {
			$table->foreign('fk_school')->references('school_id')->on('school')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('school_class_measurement', function(Blueprint $table) {
			$table->foreign('fk_class_dress')->references('dresses_id')->on('dresses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('school_class_measurement', function(Blueprint $table) {
			$table->foreign('fk_measurement_header')->references('measurement_id')->on('measurements')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('measurements', function(Blueprint $table) {
			$table->foreign('fk_dress_type')->references('dress_type_id')->on('dress_type')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('company_measurement', function(Blueprint $table) {
			$table->foreign('fk_company')->references('company_id')->on('company')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('company_measurement', function(Blueprint $table) {
			$table->foreign('fk_measurement_header')->references('measurement_id')->on('measurements')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('addons', function(Blueprint $table) {
			$table->foreign('fk_dress')->references('dresses_id')->on('dresses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('addons', function(Blueprint $table) {
			$table->foreign('fk_company')->references('company_id')->on('company')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('dresses', function(Blueprint $table) {
			$table->foreign('fk_class')->references('classes_id')->on('classes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('dresses', function(Blueprint $table) {
			$table->foreign('fk_dress_type')->references('dress_type_id')->on('dress_type')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('order_info', function(Blueprint $table) {
			$table->dropForeign('order_info_Institute_foreign');
		});
		Schema::table('order_info', function(Blueprint $table) {
			$table->dropForeign('order_info_fk_customer_id_foreign');
		});
		Schema::table('order_item_measurement', function(Blueprint $table) {
			$table->dropForeign('order_item_measurement_fk_order_item_id_foreign');
		});
		Schema::table('order_item_measurement', function(Blueprint $table) {
			$table->dropForeign('order_item_measurement_fk_dressType_foreign');
		});
		Schema::table('order_item_measurement', function(Blueprint $table) {
			$table->dropForeign('order_item_measurement_fk_measurement_header_foreign');
		});
		Schema::table('payment', function(Blueprint $table) {
			$table->dropForeign('payment_fk_order_id_foreign');
		});
		Schema::table('style', function(Blueprint $table) {
			$table->dropForeign('style_fk_order_item_id_foreign');
		});
		Schema::table('style', function(Blueprint $table) {
			$table->dropForeign('style_fk_header_foreign');
		});
		Schema::table('classes', function(Blueprint $table) {
			$table->dropForeign('classes_fk_school_foreign');
		});
		Schema::table('order_item', function(Blueprint $table) {
			$table->dropForeign('order_item_fk_order_id_foreign');
		});
		Schema::table('order_item', function(Blueprint $table) {
			$table->dropForeign('order_item_fk_dressType_foreign');
		});
		Schema::table('order_status_log', function(Blueprint $table) {
			$table->dropForeign('order_status_log_fk_order_id_foreign');
		});
		Schema::table('order_status_log', function(Blueprint $table) {
			$table->dropForeign('order_status_log_added_by_foreign');
		});
		Schema::table('ordered_addons', function(Blueprint $table) {
			$table->dropForeign('ordered_addons_fk_order_id_foreign');
		});
		Schema::table('ordered_addons', function(Blueprint $table) {
			$table->dropForeign('ordered_addons_fk_addons_foreign');
		});
		Schema::table('customer', function(Blueprint $table) {
			$table->dropForeign('customer_fk_user_id_foreign');
		});
		Schema::table('corporate_style_category', function(Blueprint $table) {
			$table->dropForeign('corporate_style_category_fk_company_foreign');
		});
		Schema::table('corporate_style_sub_category', function(Blueprint $table) {
			$table->dropForeign('corporate_style_sub_category_category_id_foreign');
		});
		Schema::table('school_class_measurement', function(Blueprint $table) {
			$table->dropForeign('school_class_measurement_fk_school_foreign');
		});
		Schema::table('school_class_measurement', function(Blueprint $table) {
			$table->dropForeign('school_class_measurement_fk_class_dress_foreign');
		});
		Schema::table('school_class_measurement', function(Blueprint $table) {
			$table->dropForeign('school_class_measurement_fk_measurement_header_foreign');
		});
		Schema::table('measurements', function(Blueprint $table) {
			$table->dropForeign('measurements_fk_dress_type_foreign');
		});
		Schema::table('company_measurement', function(Blueprint $table) {
			$table->dropForeign('company_measurement_fk_company_foreign');
		});
		Schema::table('company_measurement', function(Blueprint $table) {
			$table->dropForeign('company_measurement_fk_measurement_header_foreign');
		});
		Schema::table('addons', function(Blueprint $table) {
			$table->dropForeign('addons_fk_dress_foreign');
		});
		Schema::table('addons', function(Blueprint $table) {
			$table->dropForeign('addons_fk_company_foreign');
		});
		Schema::table('dresses', function(Blueprint $table) {
			$table->dropForeign('dresses_fk_class_foreign');
		});
		Schema::table('dresses', function(Blueprint $table) {
			$table->dropForeign('dresses_fk_dress_type_foreign');
		});
	}
}