<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class School extends Model 
{

    protected $table = 'school';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function classes()
    {
        return $this->hasMany('Classes', 'fk_school');
    }

    public function measurement()
    {
        return $this->hasMany('SchoolClassMeasurement', 'fk_school');
    }

}