<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->string('plan_name', 255);
			$table->string('package_name', 255);
			$table->bigInteger('subscription_amount');
			$table->integer('frequency_limit');
			$table->tinyInteger('status');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}