<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('subscriptions_id')->references('id')->on('subscriptions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('email_list_user_id')->references('id')->on('email_lists')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('subscriptions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('subscriptions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('email_list_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('email_list_users', function(Blueprint $table) {
			$table->foreign('email_id')->references('id')->on('email_lists')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_subscriptions_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_email_list_user_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_user_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_service_id_foreign');
		});
		Schema::table('email_list_users', function(Blueprint $table) {
			$table->dropForeign('email_list_users_user_id_foreign');
		});
		Schema::table('email_list_users', function(Blueprint $table) {
			$table->dropForeign('email_list_users_email_id_foreign');
		});
	}
}