<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('service_id')->unsigned();
			$table->integer('total_amount');
			$table->datetime('expiry_date');
			$table->tinyInteger('status');
			$table->timestamps();
			$table->timestamp('renew_at');
			$table->integer('renewal_count');
			$table->timestamp('first_renewed_at');
			$table->timestamp('last_renewed_at');
			$table->timestamp('last_cancelled_at');
			$table->timestamp('last_failed_at');
			$table->longText('note');
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}