<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntityNaturalsTable extends Migration {

	public function up()
	{
		Schema::create('entity_naturals', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('entity_id')->unsigned()->index();
			$table->integer('gender_id')->unsigned();
			$table->integer('marital_status_id')->unsigned()->nullable();
			$table->date('birth_at')->nullable();
			$table->string('birth_place')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('entity_naturals');
	}
}