<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdmin1CodesTable extends Migration {

	public function up()
	{
		Schema::create('admin1_codes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('code', 20)->unique();
			$table->string('country_code', 2)->index();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('admin1_codes');
	}
}