<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntityLegalsTable extends Migration {

	public function up()
	{
		Schema::create('entity_legals', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('entity_id')->unsigned()->index();
			$table->string('business_name')->nullable();
			$table->string('description')->nullable();
			$table->integer('domain_id')->nullable();
			$table->integer('classification_code')->nullable();
			$table->date('establishment_at')->nullable();
			$table->decimal('share_capital')->nullable()->default('0.0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('entity_legals');
	}
}