<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('entities', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('entity_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_addresses', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_addresses', function(Blueprint $table) {
			$table->foreign('type')->references('id')->on('address_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('countries', function(Blueprint $table) {
			$table->foreign('culture_id')->references('id')->on('cultures')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('countries', function(Blueprint $table) {
			$table->foreign('date_format_type_id')->references('id')->on('date_format_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_natural_identifications', function(Blueprint $table) {
			$table->foreign('entity_natural_id')->references('id')->on('entity_naturals')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_natural_identifications', function(Blueprint $table) {
			$table->foreign('identification_type_id')->references('id')->on('identification_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_legal_representatives', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_legal_representatives', function(Blueprint $table) {
			$table->foreign('natural_person_id')->references('id')->on('entity_naturals')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('banks', function(Blueprint $table) {
			$table->foreign('entity_legal_id')->references('id')->on('entity_legals')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('insurance_companies', function(Blueprint $table) {
			$table->foreign('entity_legal_id')->references('id')->on('entity_legals')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_naturals', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_naturals', function(Blueprint $table) {
			$table->foreign('gender_id')->references('id')->on('genders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_naturals', function(Blueprint $table) {
			$table->foreign('marital_status_id')->references('id')->on('marital_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_legals', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_contacts', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_contacts', function(Blueprint $table) {
			$table->foreign('contact_type_id')->references('id')->on('contact_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_category_type', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_category_type', function(Blueprint $table) {
			$table->foreign('category_type_id')->references('id')->on('category_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_contact_groups', function(Blueprint $table) {
			$table->foreign('entity_contact_id')->references('id')->on('entity_contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_contact_groups', function(Blueprint $table) {
			$table->foreign('contact_group_id')->references('id')->on('contact_groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('entities', function(Blueprint $table) {
			$table->dropForeign('entities_type_id_foreign');
		});
		Schema::table('entities', function(Blueprint $table) {
			$table->dropForeign('entities_country_id_foreign');
		});
		Schema::table('entity_addresses', function(Blueprint $table) {
			$table->dropForeign('entity_addresses_person_id_foreign');
		});
		Schema::table('entity_addresses', function(Blueprint $table) {
			$table->dropForeign('entity_addresses_type_foreign');
		});
		Schema::table('countries', function(Blueprint $table) {
			$table->dropForeign('countries_culture_id_foreign');
		});
		Schema::table('countries', function(Blueprint $table) {
			$table->dropForeign('countries_date_format_type_id_foreign');
		});
		Schema::table('entity_natural_identifications', function(Blueprint $table) {
			$table->dropForeign('entity_natural_identifications_entity_natural_id_foreign');
		});
		Schema::table('entity_natural_identifications', function(Blueprint $table) {
			$table->dropForeign('entity_natural_identifications_identification_type_id_foreign');
		});
		Schema::table('entity_legal_representatives', function(Blueprint $table) {
			$table->dropForeign('entity_legal_representatives_entity_id_foreign');
		});
		Schema::table('entity_legal_representatives', function(Blueprint $table) {
			$table->dropForeign('entity_legal_representatives_natural_person_id_foreign');
		});
		Schema::table('banks', function(Blueprint $table) {
			$table->dropForeign('banks_entity_legal_id_foreign');
		});
		Schema::table('insurance_companies', function(Blueprint $table) {
			$table->dropForeign('insurance_companies_entity_legal_id_foreign');
		});
		Schema::table('entity_naturals', function(Blueprint $table) {
			$table->dropForeign('entity_naturals_entity_id_foreign');
		});
		Schema::table('entity_naturals', function(Blueprint $table) {
			$table->dropForeign('entity_naturals_gender_id_foreign');
		});
		Schema::table('entity_naturals', function(Blueprint $table) {
			$table->dropForeign('entity_naturals_marital_status_id_foreign');
		});
		Schema::table('entity_legals', function(Blueprint $table) {
			$table->dropForeign('entity_legals_entity_id_foreign');
		});
		Schema::table('entity_contacts', function(Blueprint $table) {
			$table->dropForeign('entity_contacts_entity_id_foreign');
		});
		Schema::table('entity_contacts', function(Blueprint $table) {
			$table->dropForeign('entity_contacts_contact_type_id_foreign');
		});
		Schema::table('entity_category_type', function(Blueprint $table) {
			$table->dropForeign('entity_category_type_entity_id_foreign');
		});
		Schema::table('entity_category_type', function(Blueprint $table) {
			$table->dropForeign('entity_category_type_category_type_id_foreign');
		});
		Schema::table('entity_contact_groups', function(Blueprint $table) {
			$table->dropForeign('entity_contact_groups_entity_contact_id_foreign');
		});
		Schema::table('entity_contact_groups', function(Blueprint $table) {
			$table->dropForeign('entity_contact_groups_contact_group_id_foreign');
		});
	}
}