<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntityAddressesTable extends Migration {

	public function up()
	{
		Schema::create('entity_addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('person_id')->unsigned();
			$table->integer('type')->unsigned();
			$table->string('country_code', 2)->index();
			$table->string('admin1_code', 20);
			$table->string('admin2_code', 20);
			$table->string('admin3_code', 20);
			$table->string('admin4_code', 20)->nullable();
			$table->string('line1');
			$table->string('line2')->nullable();
			$table->string('line3')->nullable();
			$table->string('city')->nullable();
			$table->string('postal_code', 20)->nullable();
			$table->string('phone', 25)->nullable();
			$table->string('email', 100)->nullable();
			$table->decimal('latitude', 10,8)->nullable();
			$table->decimal('longitude', 11,8)->nullable();
			$table->string('timezone', 40)->nullable();
			$table->smallInteger('primary_contact')->unsigned()->index()->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('entity_addresses');
	}
}