<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIdentificationTypesTable extends Migration {

	public function up()
	{
		Schema::create('identification_types', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('code', 10)->unique();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('identification_types');
	}
}