<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUpsellsTable extends Migration {

	public function up()
	{
		Schema::create('upsells', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('upsell_type_id')->unsigned();
			$table->string('name', 191);
			$table->tinyInteger('status');
			$table->tinyInteger('auto');
			$table->longText('setting');
			$table->bigInteger('views');
			$table->bigInteger('add_to_carts');
			$table->bigInteger('transactions');
			$table->bigInteger('sales');
			$table->integer('priority');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('upsells');
	}
}