<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'phone', 'district_id', 'password', 'api_token');
	protected $hidden = array('password', 'api_token');

	public function ratings()
	{
		return $this->hasMany('App\Models\Review');
	}

	public function districts()
	{
		return $this->belongsTo('App\Models\District');
	}

	public function notifications()
	{
		return $this->morphedByMany('App\Models\Notification', 'clientable');
	}

	public function tokens()
	{
		return $this->morphedByMany('App\Models\Token', 'clientable');
	}

}