<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('address', 255);
			$table->decimal('total', 8,2)->nullable();
			$table->decimal('commission', 8,2)->nullable();
			$table->enum('payment_method', array('cash', 'online'));
			$table->double('delivery_cost', 8,2)->nullable();
			$table->double('cost', 8,2)->nullable();
			$table->enum('status', array('pending', 'processing', 'completed', 'decline', 'received'));
			$table->double('net', 8,2)->nullable();
			$table->integer('restaurant_id')->unsigned();
			$table->integer('client_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}