<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('expedition', function(Blueprint $table) {
			$table->foreign('sender_id')->references('id')->on('client')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('expedition', function(Blueprint $table) {
			$table->foreign('receiver_id')->references('id')->on('client')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('expedition', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('client', function(Blueprint $table) {
			$table->foreign('id_state')->references('id')->on('state')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('client', function(Blueprint $table) {
			$table->foreign('id_town')->references('id')->on('town')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('package', function(Blueprint $table) {
			$table->foreign('id_expedition')->references('id')->on('expedition')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('package', function(Blueprint $table) {
			$table->foreign('id_package_type')->references('id')->on('package_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('package_tracking', function(Blueprint $table) {
			$table->foreign('id_sending_agency')->references('id')->on('agency')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('package_tracking', function(Blueprint $table) {
			$table->foreign('id_reception_agency')->references('id')->on('agency')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agency', function(Blueprint $table) {
			$table->foreign('id_state')->references('id')->on('state')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agency', function(Blueprint $table) {
			$table->foreign('id_town')->references('id')->on('town')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('town', function(Blueprint $table) {
			$table->foreign('id_state')->references('id')->on('state')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('expedition', function(Blueprint $table) {
			$table->dropForeign('expedition_sender_id_foreign');
		});
		Schema::table('expedition', function(Blueprint $table) {
			$table->dropForeign('expedition_receiver_id_foreign');
		});
		Schema::table('expedition', function(Blueprint $table) {
			$table->dropForeign('expedition_user_id_foreign');
		});
		Schema::table('client', function(Blueprint $table) {
			$table->dropForeign('client_id_state_foreign');
		});
		Schema::table('client', function(Blueprint $table) {
			$table->dropForeign('client_id_town_foreign');
		});
		Schema::table('package', function(Blueprint $table) {
			$table->dropForeign('package_id_expedition_foreign');
		});
		Schema::table('package', function(Blueprint $table) {
			$table->dropForeign('package_id_package_type_foreign');
		});
		Schema::table('package_tracking', function(Blueprint $table) {
			$table->dropForeign('package_tracking_id_sending_agency_foreign');
		});
		Schema::table('package_tracking', function(Blueprint $table) {
			$table->dropForeign('package_tracking_id_reception_agency_foreign');
		});
		Schema::table('agency', function(Blueprint $table) {
			$table->dropForeign('agency_id_state_foreign');
		});
		Schema::table('agency', function(Blueprint $table) {
			$table->dropForeign('agency_id_town_foreign');
		});
		Schema::table('town', function(Blueprint $table) {
			$table->dropForeign('town_id_state_foreign');
		});
	}
}