<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Work extends Eloquent {

	protected $table = 'works';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_ar', 'name_en', 'short_desc_ar', 'short_desc_en', 'desc_ar', 'desc_en', 'image', 'category_id');
	protected $visible = array('name_ar', 'name_en', 'short_desc_ar', 'short_desc_en', 'desc_ar', 'desc_en', 'image', 'category_id');

	public function category()
	{
		return $this->belongsTo('App\Models\Category', 'category_id');
	}

}