<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAchatsTable extends Migration {

	public function up()
	{
		Schema::create('achats', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('forfait_id')->unsigned();
			$table->float('forfait_prix', 8,2);
			$table->date('date_debut')->nullable();
			$table->date('date_validite')->nullable();
			$table->date('date_achat');
			$table->integer('facture_id');
			$table->tinyInteger('numero_facture');
			$table->enum('destination', array('association', 'societe', 'prof'));
			$table->integer('proformat');
			$table->tinyInteger('convention');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('achats');
	}
}