<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Lecon extends Eloquent {

	protected $table = 'lecons';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function honoraires()
	{
		return $this->morphToMany('App\Models\Honoraires', 'honoraireable');
	}

	public function achats()
	{
		return $this->belongsTo('App\Models\Achat');
	}

	public function horaires()
	{
		return $this->belongsTo('App\Models\Horaires');
	}

}