<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Professeur extends Eloquent {

	protected $table = 'professeurs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('nom', 'prenom', 'password', 'email');

	public function honoraires()
	{
		return $this->belongsToMany('App\Models\Honoraires');
	}

	public function matieres()
	{
		return $this->morphToMany('App\Models\Matiere', 'matiereable');
	}

	public function contrats()
	{
		return $this->belongsToMany('App\Models\Contrats');
	}

	public function photos()
	{
		return $this->hasMany('App\Models\Medias');
	}

}