<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContratsTable extends Migration {

	public function up()
	{
		Schema::create('contrats', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('matiere_id')->unsigned();
			$table->enum('remuneration_style', array('pourcentage', 'eleve', 'horaire'));
			$table->decimal('remuneration', 5,2);
			$table->tinyInteger('seuil_prime_remplissage');
			$table->decimal('prime_remplissage', 4,2);
			$table->decimal('prime_1e', 4,2);
			$table->decimal('prime_2e', 4,2);
			$table->date('date');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('contrats');
	}
}