<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Atelier extends Eloquent {

	protected $table = 'ateliers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function directions()
	{
		return $this->hasMany('App\Models\Directions');
	}

	public function prospects()
	{
		return $this->belongsToMany('App\Models\Prospect');
	}

	public function horaires()
	{
		return $this->morphToMany('App\Models\Horaires', 'horaireable');
	}

	public function matieres()
	{
		return $this->morphToMany('App\Models\Matiere', 'matiereable');
	}

}