<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Contrats extends Eloquent {

	protected $table = 'contrats';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function professeurs()
	{
		return $this->belongsToMany('App\Models\Professeur');
	}

	public function salaires()
	{
		return $this->hasMany('App\Models\FacturesProfesseurs');
	}

	public function matieres()
	{
		return $this->hasMany('App\Models\Matiere');
	}

}