<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Eleve extends Eloquent {

	protected $table = 'eleves';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function achats()
	{
		return $this->belongsToMany('App\Models\Achat');
	}

	public function photos()
	{
		return $this->morphToMany('App\Models\Medias', 'photoable');
	}

}