<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Forfaits extends Eloquent {

	protected $table = 'forfaits';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function achats()
	{
		return $this->hasMany('App\Models\Achat');
	}

	public function matieres()
	{
		return $this->belongsToMany('App\Models\Matiere');
	}

}