<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Horaires extends Eloquent {

	protected $table = 'horaires';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function matieres()
	{
		return $this->morphedByMany('App\Models\Matiere', 'horaireable');
	}

	public function ateliers()
	{
		return $this->morphedByMany('App\Models\Atelier', 'horaireable');
	}

	public function achats()
	{
		return $this->belongsToMany('App\Models\Achat');
	}

	public function lecons()
	{
		return $this->hasMany('App\Models\Lecon');
	}

}