<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Matiere extends Eloquent {

	protected $table = 'matieres';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function photos()
	{
		return $this->morphToMany('App\Models\Medias', 'photoable');
	}

	public function horaires()
	{
		return $this->morphToMany('App\Models\Horaires', 'horaireable');
	}

	public function professeurs()
	{
		return $this->morphedByMany('App\Models\Professeur', 'matiereable');
	}

	public function ateliers()
	{
		return $this->morphedByMany('App\Models\Atelier', 'matiereable');
	}

	public function honoraires()
	{
		return $this->morphToMany('App\Models\Honoraires', 'honoraireable');
	}

	public function contact()
	{
		return $this->belongsTo('App\Models\Contrats');
	}

	public function forfaits()
	{
		return $this->belongsToMany('App\Models\Forfaits');
	}

}